/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexClassDefsBlock;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DexOffsetResolver {
    HashMap<String, DexOffsetDescriptor> descriptorCache = new HashMap();
    PrintStream dump;
    private static String[][] inlineMethods_35 = new String[][]{{"Lorg/apache/harmony/dalvik/NativeTestTarget", "emptyInlineMethod", "()V"}, {"Ljava/lang/String", "charAt", "(I)C"}, {"Ljava/lang/String", "compareTo", "(Ljava/lang/String;)I"}, {"Ljava/lang/String", "equals", "(Ljava/lang/Object;)Z"}, {"Ljava/lang/String", "length", "()I"}, {"Ljava/lang/Math", "abs", "(I)I"}, {"Ljava/lang/Math", "abs", "(J)J"}, {"Ljava/lang/Math", "abs", "(F)F"}, {"Ljava/lang/Math", "abs", "(D)D"}, {"Ljava/lang/Math", "min", "(II)I"}, {"Ljava/lang/Math", "max", "(II)I"}, {"Ljava/lang/Math", "sqrt", "(D)D"}, {"Ljava/lang/Math", "cos", "(D)D"}, {"Ljava/lang/Math", "sin", "(D)D"}};
    private static String[][] inlineMethods_36 = new String[][]{{"Lorg/apache/harmony/dalvik/NativeTestTarget", "emptyInlineMethod", "()V"}, {"Ljava/lang/String", "charAt", "(I)C"}, {"Ljava/lang/String", "compareTo", "(Ljava/lang/String;)I"}, {"Ljava/lang/String", "equals", "(Ljava/lang/Object;)Z"}, {"Ljava/lang/String", "fastIndexOf", "(II)I"}, {"Ljava/lang/String", "isEmpty", "()Z"}, {"Ljava/lang/String", "length", "()I"}, {"Ljava/lang/Math", "abs", "(I)I"}, {"Ljava/lang/Math", "abs", "(J)J"}, {"Ljava/lang/Math", "abs", "(F)F"}, {"Ljava/lang/Math", "abs", "(D)D"}, {"Ljava/lang/Math", "min", "(II)I"}, {"Ljava/lang/Math", "max", "(II)I"}, {"Ljava/lang/Math", "sqrt", "(D)D"}, {"Ljava/lang/Math", "cos", "(D)D"}, {"Ljava/lang/Math", "sin", "(D)D"}, {"Ljava/lang/Float", "floatToIntBits", "(F)I"}, {"Ljava/lang/Float", "floatToRawIntBits", "(F)I"}, {"Ljava/lang/Float", "intBitsToFloat", "(I)F"}, {"Ljava/lang/Double", "doubleToLongBits", "(D)J"}, {"Ljava/lang/Double", "doubleToRawLongBits", "(D)J"}, {"Ljava/lang/Double", "longBitsToDouble", "(J)D"}};
    private static final boolean DEBUG_VTABLE = false;
    private static final boolean DEBUG_OFFSETS = false;

    public void setDumpFile(PrintStream dump) {
        this.dump = dump;
    }

    public void addToOffsetResolver(DexClassDefsBlock dexClassDefsBlock) {
        Iterator<Integer> classIterator = dexClassDefsBlock.getClassIterator();
        while (classIterator.hasNext()) {
            Integer ci = classIterator.next();
            int classidx = ci;
            String className = dexClassDefsBlock.getClassNameOnly(classidx);
            DexOffsetDescriptor descriptor = new DexOffsetDescriptor(dexClassDefsBlock, classidx);
            this.descriptorCache.put(className, descriptor);
            if (this.dump == null) continue;
            this.dump.println("class added to offset resolver: " + className);
        }
    }

    public String getMethodNameFromOffset(String className, int offset) {
        DexOffsetDescriptor descriptor = this.resolveMethodOffsets(className);
        if (descriptor == null) {
            return null;
        }
        if (descriptor.methodOffsetToName == null) {
            return null;
        }
        VtableEntry entry = descriptor.methodOffsetToName.get(new Integer(offset));
        return entry == null ? null : entry.toString();
    }

    public String getFieldNameFromOffset(String className, int offset) {
        DexOffsetDescriptor descriptor = this.resolveFieldOffsets(className);
        if (descriptor == null) {
            return null;
        }
        if (descriptor.fieldOffsetToName == null) {
            return null;
        }
        if (offset < descriptor.fieldStart) {
            DexClassDefsBlock dexClassDefsBlock = descriptor.dexClassDefsBlock;
            int classIdx = descriptor.classIdx;
            String superClassName = dexClassDefsBlock.getSuperClass(classIdx);
            if (superClassName == null) {
                return null;
            }
            return this.getFieldNameFromOffset(superClassName, offset);
        }
        String fieldName = descriptor.fieldOffsetToName.get(new Integer(offset));
        return fieldName;
    }

    public static String getInlineMethodNameFromIndex(int index, DexSignatureBlock.OptVersion optVersion) {
        String[][] inlineMethodsForCurrentVersion;
        String[][] stringArray = inlineMethodsForCurrentVersion = optVersion == DexSignatureBlock.OptVersion.OPTVERSION_36 ? inlineMethods_36 : inlineMethods_35;
        if (index >= inlineMethodsForCurrentVersion.length) {
            return null;
        }
        String clazz = inlineMethodsForCurrentVersion[index][0];
        String method = inlineMethodsForCurrentVersion[index][1];
        String signature = inlineMethodsForCurrentVersion[index][2];
        return String.valueOf(clazz) + "/" + method + "," + method + signature;
    }

    public DexOffsetDescriptor resolveMethodOffsets(String inputClassName) {
        DexOffsetDescriptor descriptor;
        String className = inputClassName;
        if (className.startsWith("[")) {
            className = "java/lang/Object";
        }
        if ((descriptor = this.descriptorCache.get(className)) == null) {
            return null;
        }
        if (descriptor.methodOffsetToName != null) {
            return descriptor;
        }
        DexClassDefsBlock dexClassDefsBlock = descriptor.dexClassDefsBlock;
        DexMethodIdsBlock dexMethodIdsBlock = descriptor.dexMethodIdsBlock;
        int classIdx = descriptor.classIdx;
        String superClassName = dexClassDefsBlock.getSuperClass(classIdx);
        if (superClassName != null) {
            DexOffsetDescriptor superClassDescriptor = this.resolveMethodOffsets(superClassName);
            if (superClassDescriptor == null) {
                return null;
            }
            this.copySuperClassMethodOffsets(descriptor, superClassDescriptor);
        }
        if (descriptor.methodOffsetToName == null) {
            descriptor.initMaps();
        }
        int methodCount = descriptor.methodOffsetToName.size();
        int i = 0;
        while (i < dexClassDefsBlock.getVirtualMethodsFieldsSize(classIdx)) {
            String methodProto;
            int methodId = dexClassDefsBlock.getVirtualMethodId(classIdx, i);
            String methodName = dexMethodIdsBlock.getMethod(methodId);
            VtableEntry key = new VtableEntry(methodName, methodProto = dexMethodIdsBlock.getProto(methodId));
            if (descriptor.methodNameToOffset.get(key) == null) {
                Integer value = new Integer(methodCount);
                descriptor.methodOffsetToName.put(value, key);
                descriptor.methodNameToOffset.put(key, value);
                ++methodCount;
            }
            ++i;
        }
        i = 0;
        while (i < dexClassDefsBlock.getInterfacesSize(classIdx)) {
            String implementedInterface = dexClassDefsBlock.getInterface(classIdx, i);
            DexOffsetDescriptor ifDescriptor = this.descriptorCache.get(implementedInterface);
            DexClassDefsBlock ifDefsBlock = ifDescriptor.dexClassDefsBlock;
            int ifIdx = ifDescriptor.classIdx;
            int n = 0;
            while (n < dexClassDefsBlock.getVirtualMethodsFieldsSize(ifIdx)) {
                String methodProto;
                int methodId = dexClassDefsBlock.getVirtualMethodId(ifIdx, n);
                String methodName = dexMethodIdsBlock.getMethod(methodId);
                VtableEntry key = new VtableEntry(methodName, methodProto = dexMethodIdsBlock.getProto(methodId));
                if (descriptor.methodNameToOffset.get(key) == null) {
                    Integer value = new Integer(methodCount);
                    descriptor.methodOffsetToName.put(value, key);
                    descriptor.methodNameToOffset.put(key, value);
                    ++methodCount;
                }
                ++n;
            }
            ++i;
        }
        if (this.dump != null) {
            this.dumpMethodOffsets(this.dump, descriptor);
        }
        return descriptor;
    }

    public DexOffsetDescriptor resolveFieldOffsets(String className) {
        boolean oddRefs;
        String type2;
        String fieldName2;
        String type;
        String fieldName;
        int instanceFieldSize;
        DexOffsetDescriptor descriptor = this.descriptorCache.get(className);
        if (descriptor == null) {
            return null;
        }
        if (descriptor.fieldOffsetToName != null) {
            return descriptor;
        }
        DexClassDefsBlock dexClassDefsBlock = descriptor.dexClassDefsBlock;
        int classIdx = descriptor.classIdx;
        String superClassName = dexClassDefsBlock.getSuperClass(classIdx);
        if (superClassName != null) {
            DexOffsetDescriptor superClassDescriptor = this.resolveFieldOffsets(superClassName);
            if (superClassDescriptor == null) {
                return null;
            }
            descriptor.fieldEnd = descriptor.fieldStart = superClassDescriptor.fieldEnd;
        }
        if ((instanceFieldSize = dexClassDefsBlock.getInstanceFieldsSize(classIdx)) == 0) {
            return descriptor;
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        int i = 0;
        while (i < instanceFieldSize) {
            String fieldNameAndType = dexClassDefsBlock.getInstanceFieldNameAndType(classIdx, i);
            fieldList.add(fieldNameAndType);
            ++i;
        }
        int referenceCount = 0;
        int j = instanceFieldSize - 1;
        int i2 = 0;
        while (i2 < fieldList.size()) {
            boolean wasReference = false;
            fieldName = (String)fieldList.get(i2);
            type = this.getFieldType(fieldName);
            if (type != null) {
                if (!type.startsWith("[") && !type.startsWith("L")) {
                    while (j > i2) {
                        fieldName2 = (String)fieldList.get(j);
                        type2 = this.getFieldType(fieldName2);
                        if (type2 == null) continue;
                        if (type2.startsWith("[") || type2.startsWith("L")) {
                            fieldList.set(i2, fieldName2);
                            fieldList.set(j, fieldName);
                            wasReference = true;
                            --j;
                            break;
                        }
                        --j;
                    }
                } else {
                    wasReference = true;
                }
                if (!wasReference) break;
                ++referenceCount;
            }
            ++i2;
        }
        boolean bl = oddRefs = referenceCount & true;
        if (descriptor.fieldStart % 8 != 0) {
            boolean bl2 = oddRefs = !oddRefs;
        }
        if (oddRefs && i2 < fieldList.size()) {
            fieldName = (String)fieldList.get(i2);
            type = this.getFieldType(fieldName);
            if (!type.startsWith("J") && !type.startsWith("D")) {
                ++i2;
            } else {
                j = instanceFieldSize - 1;
                while (j > i2) {
                    fieldName2 = (String)fieldList.get(j);
                    type2 = this.getFieldType(fieldName2);
                    if (!type2.startsWith("J") && !type2.startsWith("D")) {
                        fieldList.set(i2, fieldName2);
                        fieldList.set(j, fieldName);
                        ++i2;
                        break;
                    }
                    --j;
                }
            }
        }
        j = instanceFieldSize - 1;
        while (i2 < fieldList.size()) {
            boolean wasDouble = false;
            String fieldName3 = (String)fieldList.get(i2);
            String type3 = this.getFieldType(fieldName3);
            if (type3 != null) {
                if (!type3.startsWith("J") && !type3.startsWith("D")) {
                    while (j > i2) {
                        String fieldName22 = (String)fieldList.get(j);
                        String type22 = this.getFieldType(fieldName22);
                        if (type22 == null) continue;
                        if (type22.startsWith("J") || type22.startsWith("D")) {
                            fieldList.set(i2, fieldName22);
                            fieldList.set(j, fieldName3);
                            --j;
                            wasDouble = true;
                            break;
                        }
                        --j;
                    }
                } else {
                    wasDouble = true;
                }
                if (!wasDouble) break;
            }
            ++i2;
        }
        boolean doubleEncountered = false;
        int offset = descriptor.fieldStart;
        descriptor.fieldOffsetToName = new HashMap();
        i2 = 0;
        while (i2 < fieldList.size()) {
            String fieldName4 = (String)fieldList.get(i2);
            String type4 = this.getFieldType(fieldName4);
            int fieldOffset = offset;
            switch (type4.charAt(0)) {
                case 'D': 
                case 'J': {
                    if (!doubleEncountered) {
                        doubleEncountered = true;
                        fieldOffset = offset = offset + 7 & 0xFFF8;
                    }
                    offset += 8;
                    break;
                }
                default: {
                    offset += 4;
                }
            }
            Integer fieldOffsetObject = new Integer(fieldOffset);
            descriptor.fieldOffsetToName.put(fieldOffsetObject, fieldName4);
            ++i2;
        }
        descriptor.fieldEnd = offset;
        if (this.dump != null) {
            this.dumpFieldOffsets(this.dump, descriptor);
        }
        return descriptor;
    }

    public String findCommonAncestor(String clazz1, String clazz2) {
        String bare1 = this.cutToClassName(clazz1);
        String bare2 = this.cutToClassName(clazz2);
        DexOffsetDescriptor descriptor1 = this.descriptorCache.get(bare1);
        DexOffsetDescriptor descriptor2 = this.descriptorCache.get(bare2);
        if (descriptor1 == null || descriptor2 == null) {
            return "java/lang/Object";
        }
        if (descriptor1.ancestors == null) {
            descriptor1.ancestors = this.createAncestorList(bare1, descriptor1);
        }
        if (descriptor2.ancestors == null) {
            descriptor2.ancestors = this.createAncestorList(bare2, descriptor2);
        }
        int idx1 = descriptor1.ancestors.size() - 1;
        int idx2 = descriptor2.ancestors.size() - 1;
        while (idx1 >= 0 && idx2 >= 0) {
            String ancestor2;
            String ancestor1 = descriptor1.ancestors.get(idx1);
            if (!ancestor1.equals(ancestor2 = descriptor2.ancestors.get(idx2))) break;
            --idx1;
            --idx2;
        }
        if (idx1 < 0) {
            return bare1;
        }
        if (idx2 < 0) {
            return bare2;
        }
        if (++idx1 >= descriptor1.ancestors.size()) {
            return "java/lang/Object";
        }
        return descriptor1.ancestors.get(idx1);
    }

    private ArrayList<String> createAncestorList(String clazz, DexOffsetDescriptor descriptor) {
        ArrayList<String> ancestors = new ArrayList<String>();
        DexClassDefsBlock dexClassDefsBlock = descriptor.dexClassDefsBlock;
        DexOffsetDescriptor currentDescriptor = descriptor;
        ancestors.add(clazz);
        while (dexClassDefsBlock != null) {
            String ancestorName = dexClassDefsBlock.getSuperClass(currentDescriptor.classIdx);
            if (ancestorName == null) break;
            ancestors.add(ancestorName);
            if (ancestorName.equals("java/lang/Object")) break;
            currentDescriptor = this.descriptorCache.get(ancestorName);
        }
        return ancestors;
    }

    private String cutToClassName(String clazz) {
        String bare = clazz;
        if (bare.startsWith("L")) {
            bare = bare.substring(1);
        }
        if (bare.endsWith(";")) {
            bare = bare.substring(0, bare.length() - 1);
        }
        return bare;
    }

    private void copySuperClassMethodOffsets(DexOffsetDescriptor descriptor, DexOffsetDescriptor superClassDescriptor) {
        if (descriptor.methodOffsetToName == null) {
            descriptor.initMaps();
        }
        String targetClassName = descriptor.dexClassDefsBlock.getClassNameOnly(descriptor.classIdx);
        for (Integer offset : superClassDescriptor.methodOffsetToName.keySet()) {
            VtableEntry entry = superClassDescriptor.methodOffsetToName.get(offset);
            VtableEntry newEntry = new VtableEntry(String.valueOf(targetClassName) + "/" + entry.getMethodNameOnly(), entry.getProto());
            descriptor.methodOffsetToName.put(offset, newEntry);
            descriptor.methodNameToOffset.put(newEntry, offset);
        }
    }

    private void dumpMethodOffsets(PrintStream dump, DexOffsetDescriptor descriptor) {
        dump.println();
        dump.println("Method offset resolver: class " + descriptor.dexClassDefsBlock.getClassNameOnly(descriptor.classIdx));
        if (descriptor.methodNameToOffset != null) {
            for (VtableEntry entry : descriptor.methodNameToOffset.keySet()) {
                Integer offset = descriptor.methodNameToOffset.get(entry);
                dump.println("method key: " + entry + " ; offset: " + offset);
            }
        }
        dump.println();
    }

    private void dumpFieldOffsets(PrintStream dump, DexOffsetDescriptor descriptor) {
        dump.println();
        dump.println("Field offset resolver: class " + descriptor.dexClassDefsBlock.getClassName(descriptor.classIdx));
        if (descriptor.fieldOffsetToName != null) {
            for (Integer offset : descriptor.fieldOffsetToName.keySet()) {
                String fieldName = descriptor.fieldOffsetToName.get(offset);
                dump.println("field offset: " + offset + " ; field: " + fieldName);
            }
        }
        dump.println();
    }

    private String getFieldType(String fieldName) {
        int idx = fieldName.indexOf(32);
        return idx < 0 ? null : fieldName.substring(idx + 1);
    }

    class DexOffsetDescriptor {
        public DexClassDefsBlock dexClassDefsBlock;
        public DexMethodIdsBlock dexMethodIdsBlock;
        public int classIdx;
        public HashMap<Integer, VtableEntry> methodOffsetToName = null;
        public HashMap<VtableEntry, Integer> methodNameToOffset = null;
        public HashMap<Integer, String> fieldOffsetToName = null;
        public ArrayList<String> ancestors;
        int fieldStart = 8;
        int fieldEnd = 8;

        public DexOffsetDescriptor(DexClassDefsBlock dexClassDefsBlock, int classIdx) {
            this.dexClassDefsBlock = dexClassDefsBlock;
            this.dexMethodIdsBlock = dexClassDefsBlock.getDexMethodIdsBlock();
            this.classIdx = classIdx;
        }

        public void initMaps() {
            this.methodOffsetToName = new HashMap();
            this.methodNameToOffset = new HashMap();
        }
    }

    class VtableEntry {
        String methodName;
        String proto;

        public VtableEntry(String methodName, String proto) {
            this.methodName = methodName;
            this.proto = proto;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodNameOnly() {
            int idx = this.methodName.lastIndexOf(47);
            if (idx < 0) {
                return this.methodName;
            }
            return this.methodName.substring(idx + 1);
        }

        public String getProto() {
            return this.proto;
        }

        public int hashCode() {
            return this.proto.hashCode();
        }

        public boolean equals(Object otherObject) {
            if (!(otherObject instanceof VtableEntry)) {
                return false;
            }
            VtableEntry otherEntry = (VtableEntry)otherObject;
            return this.proto.equals(otherEntry.proto);
        }

        public String toString() {
            return String.valueOf(this.methodName) + "," + this.proto;
        }
    }
}

